/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.repqueries;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.SSLException;

public class DirectoryUtils {
    public static InitialDirContext getDirCtx(String host, String port, String userDN, String userPassword, boolean useSSL) throws NamingException {
        if (useSSL) {
            return DirectoryUtils.getSSLDirCtx(host, port, userDN, userPassword);
        }
        return DirectoryUtils.getDirCtx(host, port, userDN, userPassword);
    }

    private static InitialDirContext getDirCtx(String host, String port, String userDN, String userPassword) throws NamingException {
        Hashtable hashtable = DirectoryUtils.createCtxHash(host, port, userDN, userPassword);
        return new InitialDirContext(hashtable);
    }

    private static InitialDirContext getSSLDirCtx(String host, String port, String userDN, String userPassword) throws NamingException {
        Hashtable hashtable = DirectoryUtils.createCtxHash(host, port, userDN, userPassword);
        hashtable.put("java.naming.ldap.factory.socket", "oracle.ias.repqueries.InstallSSLSocketFactoryImpl");
        hashtable.put("java.naming.security.protocol", "ssl");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
        int i = 0;
        while (true) {
            ++i;
            try {
                InitialDirContext initialDirContext = new InitialDirContext(hashtable);
                return initialDirContext;
            }
            catch (NamingException ne) {
                Throwable t;
                System.out.println("Retry count " + i + " at " + new Date(System.currentTimeMillis()).toString());
                if ((t = ne.getRootCause()) instanceof SSLException && i <= 2) continue;
                throw ne;
            }
            break;
        }
    }

    private static Hashtable createCtxHash(String host, String port, String bindDN, String bindPwd) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration<Object> e = System.getProperties().keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("java.naming.") || System.getProperty(key).equals("com.evermind.server.ApplicationInitialContextFactory")) continue;
            hashtable.put(key, System.getProperty(key));
        }
        if (hashtable.get("java.naming.factory.initial") == null) {
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        hashtable.put("java.naming.provider.url", "ldap://" + host + ":" + port + "/");
        hashtable.put("java.naming.security.authentication", "simple");
        hashtable.put("java.naming.security.principal", bindDN);
        hashtable.put("java.naming.security.credentials", bindPwd);
        return hashtable;
    }
}

